local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		function m(beat,mod)
			table.insert(mods,{beat,mod});
		end
		
		function aC(beat,command)
			table.insert(actorCmds,{beat,command});
		end
		
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local column1 = '*10 flip,*10 no invert'
		local column2 = '*10 flip,*10 -100 invert'
		local column3 = '*10 invert,*10 no flip'
		local columnReset = '*10 no invert,*10 no flip'
		
		local NEnd = '*2 flip,*2 -100 invert,*2 split,*2 confusion'
		local columnResetE = '*10 no invert,*10 no flip,*2 no split,*99 no confusion'

		mods = {
			{0, '*99 1x,*99 dark,*99 500 drunk,*99 -250 mini,*99 confusion,*99 500 tipsy,*99 blind'},
			{4, 'no dark'},
			{32, '*99 dark'},
			{36, '*5 no tipsy,*5 no confusion'},
			{40, '*99 150 beat,*15 no drunk,*15 no mini,*99 no dark,*99 2x'},
			{119.1, '*99 no centered'},
			{128, '*10 no drunk'},
			{136, '*5 500 drunk,*5 tornado,*99 stealth,*99 dark'},
			{140, 'no stealth,no dark'},
			{150, 'dark,*4 500 distant'},
			{162, '*99 overhead,*99 no tipsy'},
			{172, '*0.5 no dark'},
			{184, '*5 no tornado,*5 no drunk'},
			{192.1, '*10 no tipsy,*10 no beat'},
			{199.1, '*99 no centered'},
			{200, '*10 500 flip,*2 dark'},
			{202, '*10 no flip,*2 no dark'},
			{204, '*99 250 beat'},
			{232.1, '*99 no beat'},
			{235, '*99 -250 beat,*99 no centered', column1},
			{235.5, columnReset},
			{236, '*3 tipsy,*99 55 stealth'},
			{236.25, '*2 no stealth'},
			{284, '*99 no tipsy'},
			{292.1, '*99 no centered'},
			{300, '*10 250 tipsy,*10 250 drunk,*5 -50 flip,*3 dark,*3 stealth,*3 2.5x'},
			{303, '*5 no tipsy,*5 no drunk,no dark,no stealth'},
			{399.1, '*99 no centered,*99 2x'},
			{448, '*99 no centered,*10 -250 mini,*10 confusion,dark,*10 500 drunk,*10 500 tipsy'}
		}
		
minis={{55,55.5},{71,71.5},{87,87.5},{103,103.5},{119,119.5},{135,135.5},{199,199.5},{267,267.5},{399,399.5}}

for i,v in pairs(minis) do
    for beat=v[1],v[2] do
        m(beat, '*99 200 mini')
        m(beat+.25, '*55 no mini')
		m(beat+.5, '*99 200 mini')
        m(beat+.75, '*55 no mini')
    end
end

centers={{104,118},{196,198},{232,234},{284,291},{368,398},{416,447}}

for i,v in pairs(centers) do
    for beat=v[1],v[2] do
        m(beat+.25, '*7 300 centered')
		m(beat, '*99 no centered')
    end
end

for beat=74,103,2 do
	m(beat, '*99 no reverse,*99 no alternate,*99 no cross')
end

for beat=72,103,4 do
	m(beat, '25 reverse,50 alternate,20 cross')
end

for beat=120,127,1 do
	m(beat, '*10 200 drunk')
	m(beat+.5, '*10 -200 drunk')
end

tipsies={{128,134},{296,299}}

for i,v in pairs(tipsies) do
    for beat=v[1],v[2] do
        m(beat, '*20 200 tipsy')
		m(beat+.25, '*20 -200 tipsy')
		m(beat+.5, '*20 200 tipsy')
		m(beat+.75, '*20 -200 tipsy')
    end
end

for beat=192,192.5,1 do
	m(beat, column3)
	m(beat+.25, columnReset)
	m(beat+.5, column3)
	m(beat+.75, columnReset)
end

for beat=194,194.5,1 do
	m(beat, column2)
	m(beat+.25, columnReset)
	m(beat+.5, column2)
	m(beat+.75, columnReset)
end

for beat=292,295,1 do
	m(beat, '*99 reverse,*99 -250 mini')
	m(beat+.25, '*10 no mini')
	m(beat+.5, '*99 no reverse,*99 -250 mini')
	m(beat+.75, '*10 no mini')
end

for beat=305,367,2 do
	m(beat, '*99 250 tipsy,*20 150 flip')
	m(beat+.25, '*8 no tipsy')
end

for beat=307,367,4 do
	m(beat, '*99 -250 tipsy,*20 -50 flip')
	m(beat+.25, '*8 no tipsy')
end

for beat=400,415,2 do
	m(beat, NEnd)
	m(beat+.75, columnResetE)
end

		local beep = function()
			p1:bob():effectmagnitude(0, 50, 0):effectperiod(0.01)
			p2:bob():effectmagnitude(0, 50, 0):effectperiod(0.01)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
		end

		local excitement = function()
			for i=1, #players do
				players[i]
					:vibrate()
					:effectmagnitude(0, 900, 0)
			end
		end

		local ending = function()
			for i=1, #players do
				players[i]
					:spin()
					:effectmagnitude(0, 500, 0)
			end
		end

		local poReset = function()
			for i=1, #players do
				players[i]
					:stopeffect()
					:linear(0.125)
					:rotationz(0)
			end
		end
		
		local IntaReset = function()
			for i=1, #players do
				players[i]
					:stopeffect()
					:rotationy(0)
			end
		end

		local spin = function()
			p1:spin():effectmagnitude(0, 0, 100)
			p2:spin():effectmagnitude(0, 0, 100)
		end

		local DHallw = function()
			p1:wag():effectmagnitude(45, 0, 0):effectclock('beat')
			p2:wag():effectmagnitude(45, 0, 0):effectclock('beat')
		end
		
		local scren = function()
			screen:vibrate():effectmagnitude(0, 65, 0)
		end
		
		local screnStap = function()
			screen:stopeffect()
		end

		actorCmds = {
			{10, excitement},
			{32, stopEffect},
			{136, function()
				screen
					:queuemessage('WhiteFlash')
			end},
			{232, poReset},
			{292, poReset},
			{300, function()
				local multi = -1 if i==2 then multi = 1 end
				p1:smooth(1):x(SCREEN_CENTER_X+32*multi)
				p2:smooth(1):x(SCREEN_CENTER_X+32*-multi)
			end},
			{368, DHallw},
			{400, stopEffect},
			{400.1, function()
				for i=1, #players do
					players[i]
						:x(SCREEN_CENTER_X)
				end
			end},
			{416, ending},
			{448, IntaReset}
		}
		
for beat=74,135,2 do
	aC(beat, stopEffect)
end

for beat=72,135,4 do
	aC(beat, beep)
end

for beat=220,283,8 do
	aC(beat, poReset)
end

for beat=212,283,16 do
	aC(beat, spin)
end

earthquake={{216,220},{248,252},{264,268},{280,284},{316,320},{332,336},{348,352},{364,368},{380,384},{396,400}}

for i,v in pairs(earthquake) do
    for beat=v[1],v[2],16 do
        aC(beat, scren)
    end
end

earthquakeS={{220,221},{252,253},{268,269},{284,285},{320,321},{336,337},{352,353},{368,369},{384,385},{400,401}}

for i,v in pairs(earthquakeS) do
    for beat=v[1],v[2],4 do
        aC(beat, screnStap)
    end
end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Sprite{
    InitCommand= cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomtowidth,SCREEN_WIDTH;zoomtoheight,SCREEN_HEIGHT),
    OnCommand= cmd(),
    Texture= "lines.png",
  },
	
	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
	
	Def.Quad{
	OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,0),
	WhiteFlashMessageCommand=cmd(finishtweening;diffuse,1,1,1,1;linear,0.6;diffusealpha,0),},
	
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_1)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.25)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_2)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.75)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_1)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			local Combo1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Combo');
			if Combo1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Combo')); 
				Combo1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.25)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_2)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Combo');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Combo')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.75)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8)
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
}
